/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* Copyright 1996, LP Elektronik GmbH */

/* SCRobinson; 25.11.97; added timeout capabilities (IOCTL_HIF_SET_TIMEOUT) */

/***************************************************************************
 * DESCRIPTION                                                                        
 * This module contains ... .                                                                        
 *                                                                         
 ***************************************************************************
 * $Workfile: b_2khif.h $                                                     
 *                                                                            
 *                                                                            
 * $History: b_2khif.h $
 * 
 * *****************  Version 8  *****************
 * User: Cwn          Date: 20.11.97   Time: 8:32
 * Updated in $/HP/FastHost/SW/DEFS
 * Change IO-Control Code-Defines for WinNT
 * 
 * *****************  Version 7  *****************
 * User: Cwn          Date: 18.11.97   Time: 17:33
 * Updated in $/HP/FastHost/SW/Defs
 * new error code defined FASTHIF_ERR_PLD_PROGRAM
 * 
 * *****************  Version 6  *****************
 * User: Cwn          Date: 17.11.97   Time: 15:03
 * Updated in $/HP/FastHost/SW/DEFS
 * Device-ID and Vendor-ID changed
 * 
 * *****************  Version 5  *****************
 * User: Cwn          Date: 23.06.97   Time: 14:16
 * Updated in $/HP/FastHost/SW/Defs
 * Define APPLICATION_ERROR_MASK depends from Os-Version
 * 
 * *****************  Version 4  *****************
 * User: Cwn          Date: 20.06.97   Time: 14:16
 * Updated in $/HP/FastHost/SW/Defs
 * new error codes added
 * 
 * *****************  Version 3  *****************
 * User: Cwn          Date: 24.05.97   Time: 9:56
 * Updated in $/HP/FastHost/SW/DEFS
 * 
 * *****************  Version 2  *****************
 * User: Cwn          Date: 23.04.97   Time: 16:18
 * Updated in $/HP/FastHost/SW/DEFS
 * 
 * *****************  Version 1  *****************
 * User: Cwn          Date: 21.04.97   Time: 8:20
 * Created in $/HP/FastHost/SW/DEFS
 * 
 *                                                                            
 *                                                                            
 *                                                                            
 ***************************************************************************/ 
 
/* $Nokeywords: $ -> no more keywords after this point */

#ifndef _INC_B_2KHIF
#define _INC_B_2KHIF

#include <timeout.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


    
#define HIF_DEVICE_NAME         L"b_hif"
#define HIF_DOS_DEVICE_NAME     "b_hif"
#define HIF_WIN95_DEVICE_NAME   "b_95hif"   /* leave out the .vxd */
#define SERVICE_EXE_NAME    HIF_DOS_DEVICE_NAME


/* Useful macro for creating our own software exception codes */
#define MAKESOFTWAREEXCEPTION(Severity, Facility, Exception) \
   ((ULONG) ( \
   /* Severity code */     (Severity  <<  0) |     \
   /* MS(0) or Cust(1) */  (1         << 29) |     \
   /* Reserved(0) */       (0         << 28) |     \
   /* Facility code */     (Facility  << 16) |     \
   /* Exception code */    (Exception <<  0)))


/* define the error group base numbers       */
/* each group has 65535 possible error codes */

#ifdef _VXD_
#define ERROR_SEVERITY_ERROR       0xE0000000
#endif

#define FACILITY_HIF			1

/* can't establish connection */
#define FASTHIF_ERR_CANT_CONNECT    MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 1)

/* pld access error */
#define FASTHIF_ERR_PLD_ACCESS      MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 2)

/* pld timeout error */
#define FASTHIF_ERR_PLD_TIMEOUT     MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 3)

/* pld wait error */
#define FASTHIF_ERR_PLD_WAIT        MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 4)

/* TC not ready to receive */
#define FASTHIF_ERR_NOT_RTR         MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 5)

/* TC not ready to send */
#define FASTHIF_ERR_NOT_RTS         MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 6)

/* pld program error */
#define FASTHIF_ERR_PLD_PROGRAM     MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 7)

#define FASTHIF_ERR_BYTEACCESS      MAKESOFTWAREEXCEPTION(ERROR_SEVERITY_ERROR, FACILITY_HIF, 8)

/* Define our own private IOCTL */

#if(_WIN32_WINNT >= 0x0400)

#define FILE_DEVICE_FASTHIF  0x00008100
#define FASTHIF_IOCTL_INDEX  0x810

#define IOCTL_HIF_CONNECT    CTL_CODE (FILE_DEVICE_FASTHIF, \
                                       FASTHIF_IOCTL_INDEX, \
                                       METHOD_BUFFERED,     \
                                       FILE_ANY_ACCESS)

#define IOCTL_HIF_DISCONNECT CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 1, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

#define IOCTL_HIF_WRITE_DIRECT  CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 2, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

#define IOCTL_HIF_READ_DIRECT   CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 3, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

#define IOCTL_HIF_PROG_PLD    CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 4, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

#define IOCTL_HIF_GET_SLOT    CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 5, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

/* SCR; 25.11.97 */
#define IOCTL_HIF_SET_TIMEOUT CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 6, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS) 

/* SCR; 26.11.97 */
#define IOCTL_HIF_ISCONNECTED CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 7, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)

/* SCR; 18.6.98 */
#define IOCTL_HIF_ISDISCONNECTED CTL_CODE (FILE_DEVICE_FASTHIF,     \
                                       FASTHIF_IOCTL_INDEX + 8, \
                                       METHOD_BUFFERED,         \
                                       FILE_ANY_ACCESS)


#else

#define IOCTL_HIF_CONNECT       1
#define IOCTL_HIF_DISCONNECT    2
#define IOCTL_HIF_WRITECTRL     3
#define IOCTL_HIF_READCTRL      4
#define IOCTL_HIF_WRITE_DIRECT  5
#define IOCTL_HIF_READ_DIRECT   6

#define IOCTL_HIF_PROG_PLD      7

#define IOCTL_HIF_GET_SLOT      8

#define IOCTL_HIF_SET_TIMEOUT   9           /* SCR; 25.11.97 */
#define IOCTL_HIF_ISCONNECTED   10          /* SCR; 26.11.97 */
#define IOCTL_HIF_ISDISCONNECTED   11       /* SCR; 18.6.98 */

#endif


/* PCI definitions */
#define HIF_PCI_VENDOR_ID       0x103C
#define HIF_PCI_DEVICE_ID       0x2920
#define HIF_PIC_BASE_CLASS      7           /* communication controller */
#define HIF_PCI_SUB_CLASS       0x80        /* other communication device */


/* memory and i/o space definitions */

/* NOTE; do not read/write the full 0x20000 range ... 
 * the card drops the connection after writing byte 0x1ffff !!! */

#define HIF_IO_CONTROL_RANGE        8           /* cs 0 i/o space    */
#define HIF_MEM_MAPPED_READ_RANGE   0x20000     /* cs 1 memory space */
#define HIF_MEM_MAPPED_WRITE_RANGE  0x20000     /* cs 2 memory space */
#define HIF_MEM_READ_RANGE          0x1f000     /* max write */
#define HIF_MEM_WRITE_RANGE         0x1f000     /* max read */
#define HIF_PLD_RANGE               1           /* cs 3 pld */




/* control range register definitions */
#define HIF_IO_DATA_REG         0           /* data register (write/read) */

#define HIF_IO_CONTROL_REG      1           /* control register (write/read) */
#define HIF_IO_CONTROL_SEL_IN   0x01        /* bit 0: port signal */
#define HIF_IO_CONTROL_STRB     0x02        /* bit 1: port signal */    
#define HIF_IO_CONTROL_DIRECT   0x04        /* bit 2: port signal */
#define HIF_IO_CONTROL_WRITE    0x08        /* bit 3: port signal */
#define HIF_IO_CONTROL_RES4     0x10        /* bit 4: hardwired to 0 */
#define HIF_IO_CONTROL_START    0x20        /* bit 5: 1 = connect(ed) to TC */
#define HIF_IO_CONTROL_MODE     0x40        /* bit 6: 1 = FastHost mode, 0 = normal mode */
#define HIF_IO_CONTROL_ERROR    0x80        /* bit 7: reset error condition */
        

#define HIF_IO_STATUS_REG       2           /* status register (read) */
#define HIF_IO_STATUS_SEL       0x01        /* bit 0: port signal */    
#define HIF_IO_STATUS_RTR       0x02        /* bit 1: port signal */
#define HIF_IO_STATUS_RTS       0x04        /* bit 2: port signal */
#define HIF_IO_STATUS_WAIT      0x08        /* bit 3: port signal */

#define HIF_IO_STATUS_RES4      0x10        /* bit 4: hardwired to 1 */
#define HIF_IO_STATUS_CONNECT   0x20        /* bit 5: 1 = connection to TC established */
#define HIF_IO_STATUS_TIMEOUT   0x40        /* bit 6: 1 = timeout error */
#define HIF_IO_STATUS_ERROR     0x80        /* bit 7: 1 = error condition */


/* defines for resource structure */
#define HIF_NUM_OF_RESOURCES    4

#define HIF_RES_IO_CONTROL      0           /* command registers */
#define HIF_RES_READ            1           /* direct mode read */
#define HIF_RES_WRITE           2           /* direct mode write */
#define HIF_RES_PLD             3           /* PLD port */



#if (DEVL == 1)
#   define _DDK_BUILD
#endif

#ifdef  _DDK_BUILD

#if DBG
#define DBG_PRINT(arg) (void)DbgPrint arg
#else
#define DBG_PRINT(arg)
#endif

/*******************************************************************************
*                                 INCLUDES
*/

/* single-line comment contains line-continuation character */
#pragma warning (disable: 4010)

/* C4115 'type' : named type definition in parentheses */
#pragma warning (disable: 4115)

/* C4201 nonstandard extension used : nameless struct/union */
#pragma warning (disable: 4201)

/* C4214 nonstandard extension used : bit field types other than int */
#pragma warning (disable: 4214)

#pragma warning (disable: 4514)

#include <ntddk.h>
#include <devioctl.h>
#include <ntdef.h>
#include <winerror.h>
#include <string.h>

#pragma warning (default: 4010 4115 4201 4214 )

/*******************************************************************************
*                                 DEFINES
*/                    

/* HL, 15-aug-00
   The following code is copied from windef.h. Since we no longer include this
   ourselves, it is needed now */
#ifndef NOMINMAX

#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

#endif  /* NOMINMAX */

/* there are 256 possible busses */
#define PCI_MAX_BUSSES 256


/*******************************************************************************
*                                 TYPEDEFS
*/
/* A structure decribing a particular device resource */
typedef struct _HIF_RESOURCE
{
  PHYSICAL_ADDRESS PhysicalAddress;
  ULONG Length;
  ULONG AddressSpace;
  ULONG RangeSharable;
} HIF_RESOURCE, *PHIF_RESOURCE;
/* Structure used to pass information to/from the stat driver and apps */
typedef struct _IOCTL_INFORMATION
{
  ULONG dwTime;
  ULONG dwIrqNum;
} IOCTL_INFORMATION, *PIOCTL_INFORMATION;


/* device extension */
typedef struct _FASTHIF_DEVICE_EXTENSION
{
  PDEVICE_OBJECT DeviceObject;

  UNICODE_STRING SymbolicLinkName;
  PUCHAR IoBaseAddress;         /* pointer to command registers */
  BOOLEAN bIoBaseMapped;
  PUCHAR ReadAddress;           /* pointer to read area */
  BOOLEAN bReadAddressMapped;
  PUCHAR WriteAddress;          /* pointer to write area */
  BOOLEAN bWriteAddressMapped;

  PUCHAR PldBaseAddress;        /* pointer to PLD port */
  BOOLEAN bPldBaseMapped;

  PCM_RESOURCE_LIST resourceList; /* list of used resources */
  ULONG sizeOfResourceList;     /* size of the resource list */
  BOOLEAN bResourcesClaimed;    /* TRUE if resources are already claimed */
  ULONG dwSlotNumber;           /* pci slot used by device */
  ULONG ioCtlCode;
  IOCTL_INFORMATION IoctlInfo;

  BESTTIMEOUTS CommTimeouts;    /* SCR; 25.11.97 */
  BOOLEAN fDeviceOpen;		/* HL 15-Aug-2000 */

  PDEVICE_OBJECT LowerDeviceObject;
  PDEVICE_OBJECT PhysicalDeviceObject;
  UNICODE_STRING ifname;

  ULONG cardnr;
} FASTHIF_DEVICE_EXTENSION, *PFASTHIF_DEVICE_EXTENSION;

/*******************************************************************************
*                                 GLOBALS
*/

/*******************************************************************************
*                                 LOCALS
*/

static BESTTIMEOUTS defTimeouts = NO_TIMEOUTS; /* SCR; 25.11.97 */
static ULONG dwNumOfHIFCards = 0;    /* count the found cards */

/*******************************************************************************
*                                 MACROS
*/

/* Write control register */
#define HIFWriteIoControlReg(x) WRITE_PORT_UCHAR(pExtension->IoBaseAddress + HIF_IO_CONTROL_REG, x);

/* read control register */
#define HIFReadIoControlReg()   READ_PORT_UCHAR(pExtension->IoBaseAddress + HIF_IO_CONTROL_REG)

/* Read status register */
#define HIFReadIoStatusReg()    READ_PORT_UCHAR(pExtension->IoBaseAddress + HIF_IO_STATUS_REG)

/* IsDisConnected() returns whether the Best still thinks that it is
 * connected to the FastHIF card...as opposed to IsConnected()
 * which returns true if both SEL's are high */

#define IsConnected() (HIFReadIoStatusReg() & HIF_IO_STATUS_CONNECT)
#define IsDisConnected() (HIFReadIoStatusReg() & HIF_IO_STATUS_SEL)


/*******************************************************************************
*                           FUNCTION PROTOTYPES
*/

NTSTATUS DriverEntry(PDRIVER_OBJECT DriverObject, PUNICODE_STRING RegistryPath);
NTSTATUS HIFOpen(PDEVICE_OBJECT DeviceObject, PIRP Irp);
NTSTATUS HIFClose(PDEVICE_OBJECT DeviceObject, PIRP Irp);
NTSTATUS HIFIoctl(PDEVICE_OBJECT DeviceObject, PIRP Irp);
VOID HIFStartIo(PDEVICE_OBJECT DeviceObject, PIRP Irp);
VOID HIFUnload(PDRIVER_OBJECT DriverObject);
NTSTATUS IrpForwardAndWait(PDEVICE_OBJECT deviceObject, PIRP Irp);
NTSTATUS IrpRequestComplete(PDEVICE_OBJECT deviceObject, PIRP Irp, PKEVENT pev);
NTSTATUS IrpCompleteRequest(IN PIRP Irp, IN NTSTATUS status, IN ULONG_PTR info);
NTSTATUS IrpDefaultPnpHandler(IN PDEVICE_OBJECT fdo, IN PIRP Irp);
ULONG HIFConnect(PFASTHIF_DEVICE_EXTENSION);
ULONG HIFDisconnect(PFASTHIF_DEVICE_EXTENSION);
ULONG HIFWriteControlled(PFASTHIF_DEVICE_EXTENSION, UCHAR * pbyData, ULONG dwBlockLen, 
                         ULONG * pdwNumWritten);
ULONG HIFReadControlled(PFASTHIF_DEVICE_EXTENSION, UCHAR * pbyData, ULONG dwBlockLen,
                              ULONG * pdwNumRead);
ULONG HIFWriteBlock(PFASTHIF_DEVICE_EXTENSION pExtension, PUCHAR pvInputBuffer,
                          ULONG dwBlockLen);
ULONG HIFReadBlock(PFASTHIF_DEVICE_EXTENSION pExtension,PUCHAR pvOutputBuffer,
                         ULONG dwBlockLen);
ULONG HIFCheckHwTimeout(PFASTHIF_DEVICE_EXTENSION pExtension);
ULONG HIFWriteByte(PFASTHIF_DEVICE_EXTENSION pExtension, UCHAR byData);
ULONG HIFReadByte(PFASTHIF_DEVICE_EXTENSION pExtension, UCHAR * pbyData);
UCHAR HIFDummyRead(IN PFASTHIF_DEVICE_EXTENSION pExtension);
VOID PCIConfigPrint(ULONG dwBus, ULONG dwDeviceNumber, ULONG dwFunctionNumber, 
                    PPCI_COMMON_CONFIG PciData);
BOOLEAN HIFReportUsage(PDRIVER_OBJECT DriverObject, PDEVICE_OBJECT DeviceObject, 
                       PHIF_RESOURCE pResource, ULONG NumberOfResources);
void HIFUnReportUsage(PDRIVER_OBJECT DriverObject, PDEVICE_OBJECT DeviceObject);
PVOID HIFGetTranslatedMemory(INTERFACE_TYPE BusType, ULONG BusNumber, PHIF_RESOURCE pResource, \
                             PBOOLEAN MappedAddress);
BOOLEAN     HIFProgXC9500
#ifdef WINNT
    (PUCHAR     pbyPldPort
#else
    (WORD       pbyPldPort
#endif
    ,PUCHAR     pXSVFData);

#endif /* DDK_BUILD */

#ifdef __cplusplus
}
#endif


#endif  /* _INC_B_2KHIF */

/* end of file */
